/* --------------------------------------------------------------
  CacheApi.js 2019-06-07
  Gambio GmbH
  http://www.gambio.de
  Copyright (c) 2019 Gambio GmbH
  Released under the GNU General Public License (Version 2)
  [http://www.gnu.org/licenses/gpl-2.0.html]
  --------------------------------------------------------------*/


'use strict';

import Ajax from '../libs/Ajax';

export default {
	/**
	 * Renew the CSS cache of the selected style.
	 *
	 * @param {String} mainCssUrl The complete URL of the #main-css element of the template.
	 * @param {String} styleName (optional) The name of the style to be renewed. If not provided the active style will
	 * be renewed.
	 *
	 * @return {jQuery.jqXHR}
	 */
	renew(mainCssUrl, styleName) {
		StyleEdit.Validator.isString(mainCssUrl);
		
		// Replace the existing GET parameters with the "renew_cache".
		if (mainCssUrl.indexOf('?') !== -1) {
			mainCssUrl = mainCssUrl.replace(/\?.*/, '?renew_cache=1');
		} else {
			mainCssUrl += '?renew_cache=1';
		}
		
		if (styleName !== undefined) {
			StyleEdit.Validator.isString(styleName);
			mainCssUrl += '&style_name=' + encodeURIComponent(styleName);
		}
		
		return Ajax.get(mainCssUrl);
	}
}


